<?php
/*
 * This file is part of Totara LMS
 *
 * Copyright (C) 2016 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Petr Skoda <petr.skoda@totaralearning.com>
 * @package auth_connect
 */


namespace auth_connect\task;

use auth_connect\util;

defined('MOODLE_INTERNAL') || die();

/**
 * Client-server handshake - executed right after upgrade.
 */
class handshake_adhoc_task extends \core\task\adhoc_task  {
    /**
     * Constructor.
     */
    public function __construct() {
        $this->set_component('auth_connect');
    }

    /**
     * Do the job.
     */
    public function execute() {
        if (!is_enabled_auth('connect')) {
            return;
        }
        util::update_api_versions();
    }
}
