<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Category enrolment plugin event handler definition.
 *
 * @package   enrol_category
 * @category  event
 * @copyright 2010 Petr Skoda {@link http://skodak.org}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$observers = array (

    array (
        'eventname' => '\core\event\role_assigned',
        'callback'  => 'enrol_category_observer::role_assigned',
    ),

    array (
        'eventname' => '\core\event\role_unassigned',
        'callback'  => 'enrol_category_observer::role_unassigned',
    ),

    // Totara performance tricks.

    array (
        'eventname' => '\totara_core\event\bulk_role_assignments_started',
        'callback'  => 'enrol_category_observer::bulk_started',
    ),

    array (
        'eventname' => '\totara_core\event\bulk_role_assignments_ended',
        'callback'  => 'enrol_category_observer::bulk_finished',
    ),

);
