<?php
/*
 * This file is part of Totara LMS
 *
 * Copyright (C) 2010 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Simon Coggins <simon.coggins@totaralms.com>
 * @package totara
 * @subpackage plan
 */

$string['achieved'] = 'Achieved';
$string['achievedvaluefrozen'] = 'You cannot change this setting because the scale is in use';
$string['action'] = 'Action';
$string['actionlinks'] = 'Actions';
$string['actions'] = 'Actions';
$string['activateplan'] = 'Activate Plan';
$string['active'] = 'Active';
$string['activecertifications'] = 'Certifications';
$string['activecertificationssubhead'] = 'Active Certifications';
$string['activecompetencies'] = 'Competencies';
$string['activecompetenciessubhead'] = 'Active Competencies';
$string['activecourses'] = 'Courses';
$string['activecoursessubhead'] = 'Active Courses';
$string['activeevidence'] = 'Other Evidence';
$string['activeevidencesubhead'] = 'Active Evidence';
$string['activelearning'] = 'Active Learning';
$string['activeobjectives'] = 'Objectives';
$string['activeobjectivessubhead'] = 'Active Objectives';
$string['activeplans'] = 'Active Plans';
$string['activeprograms'] = 'Programs';
$string['activeprogramssubhead'] = 'Active Programs';
$string['add'] = 'Add {$a}';
$string['addcompetencys'] = 'Add competencies';
$string['addcourses'] = 'Add courses';
$string['addedx'] = 'Added "{$a}"';
$string['addevidence'] = 'Add evidence';
$string['addlinkedcompetencies'] = 'Add linked competencies';
$string['addlinkedcourses'] = 'Add linked courses from plan';
$string['addlinkedcoursescompetency'] = 'Add linked courses from competency';
$string['addlinkedevidence'] = 'Add linked evidence';
$string['addnewobjective'] = 'Add new objective';
$string['addnewobjectivevalue'] = 'Add new objective scale value';
$string['addnewpriorityvalue'] = 'Add new priority scale value';
$string['addobjective'] = 'Add objective';
$string['addplan'] = 'Add plan';
$string['addprograms'] = 'Add programs';
$string['addremovecompetency'] = 'Add/remove competencies';
$string['addremovecourse'] = 'Add/remove courses';
$string['addremoveprogram'] = 'Add/remove programs';
$string['addrpl'] = 'Add RPL';
$string['addtemplate'] = 'Add new Template';
$string['advancedsettingscompetencypermissions'] = 'Competency permissions';
$string['advancedsettingscompetencypermissions_help'] = '**Competency permissions** allow you to define the types of actions that can be performed by the Learner and Manager for competencies within the learning plan.

There are four permission levels available:

*   **Allow** allows the user to perform the action
*   **Deny** prevents the user from performing the action
*   **Request** allows the user to request that this action is performed
*   **Approve** allows the user to approve a requested action.';
$string['advancedsettingscompetencysettings'] = 'Competency settings';
$string['advancedsettingscompetencysettings_help'] = '**Competency settings** allow you to define which settings are available for competencies within the plan.

Select the **‘Due dates’** setting. When **‘Due dates’** is set to ‘None’ the column does not appear on the learning plan.

Select the **‘Priorities’** setting. When you are using **‘Priorities’** you need a **‘Priority Scale’**. Click the dropdown menu to select the priority scale.

**Note:** The option to set up such a scale is in Learning Plans>Priority Scales.
**Automatic assignment** enables you to automatically display competencies in a learning plan which have previously been assigned to a user’s position or organisation.

**Default status** determines the status of a competency when it is is first approved within a plan. If \'Assign newly approved competencies their default status\' is checked, all competencies will be given the default status for that competency\'s scale at the moment the competency is approved. If left unchecked no initial status will be set.';
$string['advancedsettingscoursepermissions'] = 'Course permissions';
$string['advancedsettingscoursepermissions_help'] = '**Course permissions** allow you to define which course settings are available and the types of actions that can be performed by the Learner and Manager in the learning plan.

There are four available permission levels:

*   **Allow** allows the user to perform the action
*   **Deny** prevents the user from performing the action
*   **Request** allows the user to request that this action
*   **Approve** allows the user to approve a action.';
$string['advancedsettingscoursesettings'] = 'Course settings';
$string['advancedsettingscoursesettings_help'] = '**Course settings** allow you to define the settings available for courses within the plan.

Select the **‘Due dates’** setting. When **‘Due dates’** is set to ‘None’ the column does not appear on the learning plan.

Select the **‘Priorities’** setting. When **‘Priorities’** is set to ‘None’ the column does not appear on the learning plan.

When you are using **‘Priorities’** you need a **‘Priority Scale’**. Click the dropdown menu to select the priority scale.

**Note:** The option to set up such a scale is in Learning Plans>Priority Scales.';
$string['advancedsettingsobjectivepermissions'] = 'Objective permissions';
$string['advancedsettingsobjectivepermissions_help'] = '**Objective permissions** allow you to define the actions that can be performed by the Learner and Manager in the learning plan when setting up objectives.

There are four available permission levels:

*   **Allow** allows the user to perform the action
*   **Deny** prevents the user from performing the action
*   **Request** allows the user to request that this action
*   **Approve** allows the user to approve the action.';
$string['advancedsettingsobjectivesettings'] = 'Objective settings';
$string['advancedsettingsobjectivesettings_help'] = '**Objective settings** allow you define the settings available for objectives within the plan.

Select the **‘Due dates’** setting. When **‘Due dates’** is set to ‘None’ the column does not appear on the learning plan.

Select the **‘Priorities’** setting. When **‘Priorities’** is set to ‘None’ the column does not appear on the learning plan.

When you are using **‘Priorities’** you need a **‘Priority Scale’**. Click the dropdown menu to select the priority scale.

**Note:** The option to set up such a scale is in Learning Plans>Priority Scales.

**Objective scale** is used to measure a learners’ progress towards their objectives. Set up objective scales using the menu option under Site Administration>Learning Plans.';
$string['advancedsettingsplanpermissions'] = 'Plan permissions';
$string['advancedsettingsplanpermissions_help'] = 'The advanced workflow settings allows you to define the type of actions which can be performed by learners and managers. For each type of action there are four permission levels available:

*   **Allow** allows the user to perform the action.
*   **Deny** prevents the user from performing the action.
*   **Request** allows the user to request that this action is performed.
*   **Approve** allows the user to approve an action.';
$string['advancedsettingsplansettings'] = 'Plan settings';
$string['advancedsettingsplansettings_help'] = '**Plan settings** allow you to define general settings for the plan.

The Learning Plan is able to be marked as complete based on the following choices:

*   **Manually, by a user with \'complete\' permission.**
    The learning plan is able to be marked as complete by a Learner or Manager who has Allow selected in the Approve row of the Plan Permissions.
*   **Automatically, when all items have been completed.**
    The learning plan is marked as completed when all of the courses, competencies, Objectives or programs that are included in the learning plan have been marked as completed
*   **Automatically, when the plan completion date has passed.**
    The learning plan is marked as complete when the Completion Date that has been saved with the Learning Plan has passed';
$string['advancedsettingsprogrampermissions'] = 'Program permissions';
$string['advancedsettingsprogrampermissions_help'] = 'The advanced workflow settings allows you to define the type of actions which can be performed by learners and managers. For each type of action there are four permission levels available:

*   **Allow** allows the user to perform the action.
*   **Deny** prevents the user from performing the action.
*   **Request** allows the user to request that this action is performed.
*   **Approve** allows the user to approve an action.';
$string['advancedsettingsprogramsettings'] = 'Program settings';
$string['advancedsettingsprogramsettings_help'] = 'The Learning Plan is able to be marked as complete based on the following choices:

*   **Manually, by a user with \'complete\' permission.**
    The learning plan is able to be marked as complete by a Learner or Manager who has Allow selected in the Approve row of the Plan Permissions.
*   **Automatically, when all items have been completed.**
    The learning plan is marked as completed when all of the courses, competencies, Objectives or programs that are included in the learning plan have been marked as completed
*   **Automatically, when the plan completion date has passed.**
    The learning plan is marked as complete when the Completion Date that has been saved with the Learning Plan has passed';
$string['advancedworkflow'] = 'Advanced workflow settings';
$string['after'] = 'After';
$string['allcertifications'] = 'Certifications';
$string['allcertificationssubhead'] = 'All Certifications';
$string['allcompetencies'] = 'Competencies';
$string['allcompetenciessubhead'] = 'All Competencies';
$string['allcourses'] = 'Courses';
$string['allcoursessubhead'] = 'All Courses';
$string['allevidence'] = 'Other Evidence';
$string['allevidencesubhead'] = 'All Evidence';
$string['allevidencetypes'] = 'All evidence types';
$string['alllearning'] = 'All Learning';
$string['allobjectives'] = 'Objectives';
$string['allobjectivescales'] = 'All objective scales';
$string['allobjectivessubhead'] = 'All Objectives';
$string['allow'] = 'Allow';
$string['allpriorityscales'] = 'All priority scales';
$string['allprograms'] = 'Programs';
$string['allprogramssubhead'] = 'All Programs';
$string['allteammembers'] = 'All Team Members';
$string['alreadyassignedtoplan'] = 'Already assigned to this plan';
$string['approval'] = 'Approval';
$string['approvalrequested'] = '(Approval Requested)';
$string['approvalrequestsent'] = 'Approval request sent for plan "{$a}"';
$string['approvalstatus'] = 'Approval status';
$string['approvalstatusof'] = 'Approval status of {$a}';
$string['approve'] = 'Approve';
$string['approved'] = 'Approved';
$string['approveitemstext'] = 'Please review and approve the changes to the attached plan';
$string['approvedplanrequest'] = ' Your request for the plan {$a} has been approved';
$string['approveplantext'] = 'Please review and approve the attached plan';
$string['assessitem'] = 'Assess item';
$string['assignedonly'] = 'Assigned but not used';
$string['attachment'] = 'File attachments';
$string['autoassign'] = 'Automatic assignment';
$string['autoassigncourses'] = 'Include linked courses';
$string['autoassignorg'] = 'Automatically assign by organisation';
$string['autoassignpos'] = 'Automatically assign by position';
$string['autobyitems'] = 'Automatically, when all items have been completed';
$string['autobyplandate'] = 'Automatically, when the plan completion date has passed';
$string['autocompleteplan'] = 'Automatic plan completion';
$string['autcompleteplantask'] = 'Process plan autocompletion';
$string['autocompleteplantext'] = 'Automatically set approved plans to complete after end date';
$string['autocreated'] = 'Automatically created plans';
$string['automateddefault'] = 'Automatic (added to plan)';
$string['awaitingapproval'] = 'Awaiting approval';
$string['baddata'] = 'Supplied bad data - non numeric id';
$string['basicworkflowdesc'] = 'Similar to the manager driven workflow, but with some options disabled to simplify the interface.';
$string['basicworkflowname'] = 'Basic workflow';
$string['before'] = 'Before';
$string['cannotdelete_inuse'] = 'You cannot delete this template because there are plans using it.';
$string['cannotdeletetemplate_default'] = 'Cannot delete default template';
$string['cannotdeletetemplate_inuse'] = 'Cannot delete template when it is in use';
$string['cannothidedefault'] = 'The default template cannot be hidden';
$string['cannotremoveitem'] = 'There was a problem removing that item';
$string['canremoveitem'] = 'The item was successfully removed';
$string['certificationshistoryforsubhead'] = 'Previous Certifications for {$a}';
$string['certificationshistorysubhead'] = 'All Previous Certifications';
$string['changedfromxtoy'] = 'Changed from "{$a->before}" to "{$a->after}"';
$string['changes'] = 'Changes';
$string['changeto'] = 'Change to';
$string['changeworkflowconfirm'] = 'Are you sure you wish to change the workflow for this template. This will override all settings and permissions, and use the default settings for the "{$a}".';
$string['checkplancomplete'] = 'Are you sure you want to mark the plan "{$a}" as complete?<br /><br />Once a plan is marked complete then no further changes can be made. This operation cannot be undone. Are you sure you want to proceed?';
$string['checkplancomplete11'] = 'Are you sure you want to mark the plan "{$a}" as complete?<br /><br /> Once the plan is marked complete it will be locked and will have to be reactivated to make any further changes. Are you sure you want to proceed?';
$string['checkplandelete'] = 'Are you sure you want to delete this plan and all its related items?';
$string['checkplanreactivate'] = 'Are you sure you want to reactivate the plan "{$a}"?<br />';
$string['commenterror:itemnotfound'] = 'Comment error: Comment item not found';
$string['commenterror:unsupportedcomment'] = 'Comment error: Unsupported comment';
$string['commentmsg:componentitem'] = 'New comment on {$a->component} item of {$a->planowner}\'s plan "{$a->plan}"';
$string['commentmsg:componentitemdetail'] = 'There has been a new comment on {$a->component} item of the plan.<br /><br />
<strong>Learner: </strong> {$a->planowner}<br />
<strong>Plan:</strong> {$a->plan}<br />
<strong>{$a->component}:</strong> {$a->componentname}<br />
<strong>Comment:</strong>{$a->comment} - <em>Comment by {$a->commentby} on {$a->commentdate}</em>';
$string['commentmsg:planoverview'] = 'New comment on {$a->planowner}\'s plan "{$a->plan}"';
$string['commentmsg:planoverviewdetail'] = 'There has been a new comment on the plan.<br /><br />
<strong>Learner: </strong> {$a->planowner}<br />
<strong>Plan: </strong> {$a->plan}<br />
<strong>Comment: </strong>{$a->comment} - <em>Comment by {$a->commentby} on {$a->commentdate}</em>';
$string['commenton'] = 'Comment On';
$string['comments'] = 'Comments';
$string['competencies'] = 'Competencies';
$string['competenciesachieved'] = 'Competencies achieved';
$string['competenciesplural'] = 'Competencies';
$string['competenciesupdated'] = 'Competencies updated';
$string['competency'] = 'Competency';
$string['competency_instructions_add'] = 'You can add additional competencies by clicking the "Add/remove competencies" button to the right of the screen.';
$string['competency_instructions_add11'] = 'You can add additional competencies by clicking the "Add competencies" button.';
$string['competency_instructions_detail'] = 'You can view more details about any competency by clicking its title.';
$string['competency_instructions_learner'] = 'All the competencies that will be addressed by your learning plan are shown below.';
$string['competency_instructions_manager'] = 'All the competencies that will be addressed by your team member\'s learning plan area shown below.';
$string['competency_instructions_request'] = 'Clicking "Add competencies" will allow you to request to add new competencies to this learning plan.';
$string['competencycompleted'] = 'Competency Completed';
$string['competencyevidencestatus'] = 'Evidence Status';
$string['competencyevidencestatus_help'] = 'This field records the user\'s status in the assigned competency. The options that appear in the pulldown depend on the competency scale assigned to the chosen competency, so the competency must be selected before this field can be modified. A value scale must be set to add or update a competency evidence record.';
$string['competencyname'] = 'Competency Name';
$string['competencypermissions'] = 'Competency permissions';
$string['competencyplural'] = 'Competencies';
$string['competencysettings'] = 'Competency settings';
$string['competencyview'] = 'View competency {$a}';
$string['complete'] = 'Complete';
$string['completed'] = 'Completed';
$string['completedcertifications'] = 'Certifications';
$string['completedcertificationssubhead'] = 'Completed Certifications';
$string['completedcompetencies'] = 'Competencies';
$string['completedcompetenciessubhead'] = 'Completed Competencies';
$string['completedcourses'] = 'Courses';
$string['completedcoursessubhead'] = 'Completed Courses';
$string['completedevidence'] = 'Other Evidence';
$string['completedevidencesubhead'] = 'Completed Evidence';
$string['completedlearning'] = 'Completed Learning';
$string['completedobjectives'] = 'Objectives';
$string['completedobjectivessubhead'] = 'Completed Objectives';
$string['completedplans'] = 'Completed Plans';
$string['completedprograms'] = 'Programs';
$string['completedprogramssubhead'] = 'Completed Programs';
$string['completedviarpl'] = 'Completed via RPL: {$a}';
$string['completeplan'] = 'Complete plan';
$string['completereactivate'] = 'Complete/reactivate';
$string['completiondate'] = 'Completion date';
$string['component'] = 'Component';
$string['componentapprovelonglearner'] = '{$a->component} in learning plan "{$a->plan}" approved:
{$a->updates}';
$string['componentapprovelonglearnerhtml'] = '{$a->component} in learning plan "{$a->planhtml}" approved:<br /> {$a->updateshtml}';
$string['componentapprovelongmanager'] = '{$a->component} in learning plan "{$a->plan}" approved:
{$a->updates}';
$string['componentapprovelongmanagerhtml'] = '{$a->component} in learning plan "{$a->planhtml}" approved:<br /> {$a->updateshtml}';
$string['componentapproveshortlearner'] = '{$a->name} approved';
$string['componentapproveshortmanager'] = '{$a->user} approved {$a->component} {$a->name}';
$string['componentcompletelonglearner'] = '{$a->component} in learning plan "{$a->plan}" completed:
{$a->updates}';
$string['componentcompletelonglearnerhtml'] = '{$a->component} in learning plan "{$a->planhtml}" completed:<br /> {$a->updateshtml}';
$string['componentcompletelongmanager'] = '{$a->component} in learning plan "{$a->plan}" completed:
{$a->updates}';
$string['componentcompletelongmanagerhtml'] = '{$a->component} in learning plan "{$a->planhtml}" completed:<br /> {$a->updateshtml}';
$string['componentcompleteshortlearner'] = '{$a->name} completed';
$string['componentcompleteshortmanager'] = '{$a->user} completed {$a->component} {$a->name}';
$string['componentdeclinelonglearner'] = '{$a->component} in learning plan "{$a->plan}" declined:
{$a->updates}';
$string['componentdeclinelonglearnerhtml'] = '{$a->component} in learning plan "{$a->planhtml}" declined:<br /> {$a->updateshtml}';
$string['componentdeclinelongmanager'] = '{$a->component} in learning plan "{$a->plan}" declined:
{$a->updates}';
$string['componentdeclinelongmanagerhtml'] = '{$a->component} in learning plan "{$a->planhtml}" declined:<br /> {$a->updateshtml}';
$string['componentdeclineshortlearner'] = '{$a->name} declined';
$string['componentdeclineshortmanager'] = '{$a->user} declined {$a->component} {$a->name}';
$string['componentrenaming'] = 'Component Renaming';
$string['components'] = 'Components';
$string['componentsettings'] = 'Component Settings';
$string['componentupdatelonglearner'] = '{$a->component} in learning plan "{$a->plan}" updated:
{$a->updates}';
$string['componentupdatelonglearnerhtml'] = '{$a->component} in learning plan "{$a->planhtml}" updated:<br /> {$a->updateshtml}';
$string['componentupdatelongmanager'] = '{$a->component} in learning plan "{$a->plan}" updated:
{$a->updates}';
$string['componentupdatelongmanagerhtml'] = '{$a->component} in learning plan "{$a->planhtml}" updated:<br /> {$a->updateshtml}';
$string['componentupdateshortlearner'] = '{$a} updated';
$string['componentupdateshortmanager'] = '{$a->user} updated {$a->component}';
$string['configenablelearningplans'] = 'This option will let you: Enable(show)/Disable Learning Plan features from users on this site.

* If Show is chosen, all links, menus, tabs and option related to learning plans will be accessible.
* If Disable is chosen, learning plans will disappear from any menu on the site and will not be accessible.
';
$string['confirm'] = 'Confirm';
$string['confirmcreateplans'] = 'Confirm creation of plans';
$string['confirmdeleteplantitle'] = 'Delete learning plan: {$a}';
$string['confirmitemdelete'] = 'Are you sure you want to remove this item?';
$string['confirmlinkedcourses'] = 'Confirm linked courses';
$string['confirmlinkedcoursesdesc'] = 'Some of those competencies have linked courses. If checked below, these courses will also be added to this plan:';
$string['confirmrequestapprove'] = 'Are you sure you want to approve the following request?';
$string['confirmrequestdecline'] = 'Are you sure you want to decline the following request?';
$string['couldnotinsertnewrecord'] = 'Could not insert new record';
$string['course'] = 'Course';
$string['course_instructions_add'] = 'Clicking "Add/remove Courses" will allow you to add new courses to this learning plan.';
$string['course_instructions_add11'] = 'Clicking "Add Courses" will allow you to add new courses to this learning plan.';
$string['course_instructions_detail'] = 'You can view any course by clicking the course title.';
$string['course_instructions_learner'] = 'All the courses that form your learning plan are shown below.';
$string['course_instructions_manager'] = 'All the courses that form your team member\'s learning plan are show below.';
$string['course_instructions_request'] = 'Clicking "Add courses" will allow you to request to add new courses to this learning plan.';
$string['coursecompletion'] = 'Course Completion';
$string['coursename'] = 'Course Name';
$string['coursenotfound'] = 'Course not found';
$string['coursepermissions'] = 'Course permissions';
$string['courseplural'] = 'Courses';
$string['coursescomplete'] = 'Courses complete';
$string['coursescompletionhistoryforsubhead'] = 'Previous Completions for {$a}';
$string['coursescompletionhistorysubhead'] = 'Previous Completed Courses';
$string['coursesettings'] = 'Course settings';
$string['coursesettingsnotupdated'] = 'There was a problem updating the course settings';
$string['coursesettingsupdated'] = 'Course settings updated';
$string['coursesnotupdated'] = 'There was a problem updating your courses.';
$string['coursesupdated'] = 'Course settings updated.';
$string['create'] = 'Create';
$string['createnewlearningplan'] = 'Create new learning plan';
$string['createplan'] = 'Create plan';
$string['createplan_instructions'] = 'To create a new plan please add the plan title, a short description of the plan and a date by which the plan should be completed. You can click "Create plan" once you have entered this information.';
$string['currentattachment'] = 'Current attachment';
$string['currentlyviewing'] = 'Currently Viewing';
$string['customworkflowdesc'] = 'Fine-grained control over individual permissions via advanced settings.';
$string['customworkflowname'] = 'Custom workflow';
$string['datecompleted'] = 'Date completed';
$string['datecreated'] = 'Date created';
$string['timeproficient'] = 'Proficiency achieved';
$string['timeproficient_help'] = 'Allows you to record the date the user achieved proficiency. This field is entirely optional, but will default to the current date when a proficient status is selected.';
$string['datestarted'] = 'Date started';
$string['decline'] = 'Decline';
$string['declined'] = 'Declined';
$string['declinedplanrequest'] = ' Your request for the plan {$a} has been declined.';
$string['declineplantext'] = 'You are about to decline the requested plan, please confirm';
$string['defaultobjectivescaledescription'] = 'Completed objective, objective in progress, or not started objective.';
$string['defaultobjectivescalename'] = 'Completed, In Progress, Not Started';
$string['defaultpriorityscaledescription'] = 'High priority, medium priority, or low priority.';
$string['defaultpriorityscalename'] = 'High, Medium, Low';
$string['defaultscalevaluecompleted'] = 'Completed';
$string['defaultscalevaluehigh'] = 'High';
$string['defaultscalevalueinprogress'] = 'In Progress';
$string['defaultscalevaluelow'] = 'Low';
$string['defaultscalevaluemedium'] = 'Medium';
$string['defaultscalevaluenotstarted'] = 'Not Started';
$string['defaultstatus'] = 'Default status';
$string['defaultvalue'] = 'Default value';
$string['delete'] = 'Delete';
$string['deleteattachedevidenceareyousure'] = 'Are you sure you want to delete the attached evidence?';
$string['deleteattachmentevidence'] = 'Delete attached evidence';
$string['deletecheckdptemplate'] = 'Are you sure you want to delete this learning plan template?';
$string['deletecheckevidencetype'] = 'Are you absolutely sure you want to completely delete this Evidence type?';
$string['deletecheckevidencetypeinuse'] = 'It is being used by existing evidence';
$string['deletecheckobjective'] = 'Are you absolutely sure you want to completely delete this objective scale?';
$string['deletecheckobjectivevalue'] = 'Are you absolutely sure you want to delete this objective scale value?';
$string['deletecheckpriority'] = 'Are you absolutely sure you want to completely delete this priority scale?';
$string['deletecheckpriorityvalue'] = 'Are you absolutely sure you want to delete this priority scale value?';
$string['deletedefault'] = 'Cannot delete default template';
$string['deletedevidencetype'] = 'The Evidence type "{$a}" has been completely deleted.';
$string['deletedobjectivescale'] = 'The objective scale "{$a}" has been completely deleted.';
$string['deletedobjectivescalevalue'] = 'The objective scale value "{$a}" has been deleted.';
$string['deletedp'] = 'Successfully deleted learning plan template';
$string['deletedpriorityscale'] = 'The priority scale "{$a}" has been completely deleted.';
$string['deletedpriorityscalevalue'] = 'The priority scale value "{$a}" has been deleted.';
$string['deleteevidence'] = 'Delete evidence';
$string['deleteevidenceareyousure'] = 'Are you sure you want to delete this evidence?';
$string['deletelinkedcoursesheader'] = 'Removing "{$a}" from plan';
$string['deletelinkedcoursesinstructionslearner'] = 'The following courses are linked to this competency in your plan. If checked, they will be removed from your plan at this time. If unchecked, they will remain in your plan.';
$string['deletelinkedcoursesinstructionsmanager'] = 'The following courses are linked to this competency in {$a}\'s plan. If checked, they will be removed from the plan at this time. If unchecked, they will remain in the plan.';
$string['deletelinkedcoursessubmit'] = 'Remove from plan';
$string['deletelinkedevidenceheader'] = 'Linked Evidence';
$string['deletelinkedevidencemessage'] = 'The link(s) to the following evidence will also be removed.<br />The original evidence will not be deleted however and will remain in the record of learning';
$string['deletemandatory'] = 'Delete Mandatory';
$string['deleteobjective'] = 'Delete objective';
$string['deleteobjectiveareyousure'] = 'Are you sure you want to delete this objective?';
$string['deleteplan'] = 'Delete plan';
$string['deny'] = 'Deny';
$string['draft'] = 'Draft';
$string['duedate'] = 'Due date';
$string['duedatefor'] = 'Due date for {$a}';
$string['duedatemode'] = 'Due dates';
$string['duedates'] = 'Due dates';
$string['dueinxdays'] = 'Due in {$a} day(s)';
$string['duetoday'] = 'Due today';
$string['editdetails'] = 'Edit details';
$string['editdetailswithapproval'] = 'Edit details (will require approval)';
$string['editevidence'] = 'Edit evidence';
$string['editevidencetype'] = 'Edit evidence type {$a}';
$string['editobjective'] = 'Edit objective {$a}';
$string['editobjectivevalue'] = 'Edit objective value';
$string['editpriority'] = 'Edit priority {$a}';
$string['editpriorityvalue'] = 'Edit priority value';
$string['enablelearningplans'] = 'Enable Learning Plans';
$string['enablerecordoflearning'] = 'Enable Record of Learning';
$string['enablerecordoflearninginfo'] = 'This option will let you: enable (show) or disable Record of Learning features on this site.

* If Show is selected, all features related to Record of Learning will be visible and accessible.
* If Disable is selected, no Record of Learning features will be visible or accessible.';
$string['enddate'] = 'End date';
$string['error:cannotaddscalevalue'] = 'You cannot add a scale value to a scale that is in use';
$string['error:cannotupdatecompetencies'] = 'Cannot update competencies';
$string['error:cannotupdatecourses'] = 'Cannot update courses';
$string['error:cannotupdateevidence'] = 'Cannot update evidence';
$string['error:cannotupdateobjectives'] = 'Cannot update objectives';
$string['error:cannotupdateprograms'] = 'Cannot update programs';
$string['error:cannotviewpage'] = 'You cannot view this page';
$string['error:cantcreatecustomworkflow'] = 'You cannot create a workflow called \'custom\' as this is used by the system.';
$string['error:competenciesupdated'] = 'Competencies not updated';
$string['error:competencynotfound'] = 'Competency not found';
$string['error:competencyproficiencypermission'] = 'You do not have permission to update proficiencies';
$string['error:competencystatuspermission'] = 'You do not have permission to change the status of that competency';
$string['error:couldnotassignnewitem'] = 'Could not assign new item to plan';
$string['error:couldnotfindassigneditem'] = 'Could not find assigned item';
$string['error:couldnotunassigneditem'] = 'Could not unassign item';
$string['error:coursecompletionpermission'] = 'You do not have permission to update completion status';
$string['error:createcomponents'] = 'An error occured while creating components for a new plan template';
$string['error:createnewevidencetype'] = 'An error occured while creating new Evidence type';
$string['error:createnewobjectivescale'] = 'An error occured while creating new objective scale';
$string['error:createnewpriorityscale'] = 'An error occured while creating new priority scale';
$string['error:createobjectivescale'] = 'An error occured while creating an objective scale';
$string['error:createobjectivevalue'] = 'Error creating objective scale value record';
$string['error:createpriorityvalue'] = 'Error creating priority scale value record';
$string['error:creatingobjectivescalevalues'] = 'An error occured when creating objective scale values';
$string['error:creationaftercompletion'] = 'Completion Date must not be before Date Created';
$string['error:dateformat'] = 'Please enter a date in the format {$a}.';
$string['error:deletedobjectivescalevalue'] = 'An error occured when deleting objective scale value';
$string['error:deletedp'] = 'An error occured while deleting learning plan template';
$string['error:deletedpriorityscalevalue'] = 'Could not delete priority scale value.';
$string['error:evidencedeleted'] = 'Evidence not deleted';
$string['error:evidenceidincorrect'] = 'Evidence ID incorrect';
$string['error:evidencenotfound'] = 'Evidence not found';
$string['error:evidencetypeidincorrect'] = 'Evidence type ID was incorrect';
$string['error:incorrectparameters'] = 'Incorrect parameters';
$string['error:invalid_component_id'] = 'Invalid component ID';
$string['error:invalidcomponent'] = 'Invalid component';
$string['error:invalidtemplateid'] = 'Invalid template id';
$string['error:itemnotinplan'] = 'This item is not part of specified plan';
$string['error:missingcompetencysettings'] = 'Missing Competency settings';
$string['error:missingcoursesettings'] = 'Missing Course settings';
$string['error:missingobjectivesettings'] = 'Missing Objective settings';
$string['error:missingpermissionsetting'] = 'Missing permission setting';
$string['error:missingprogramsettings'] = 'Missing Program settings';
$string['error:newdptemplate'] = 'An error occured while creating a new learning plan template';
$string['error:nodeleteobjectivescaleassigned'] = 'You cannot delete that objective scale because it is already assigned in one or more plan templates';
$string['error:nodeleteobjectivescaleinuse'] = 'You cannot delete that objective scale because it is in use';
$string['error:nodeleteobjectivescalevaluedefault'] = 'You cannot delete that objective scale value because it is the default value';
$string['error:nodeleteobjectivescalevalueinuse'] = 'You cannot delete that scale value because it\'s scale is in use';
$string['error:nodeletepriorityscaleassigned'] = 'You cannot delete that priority scale because it is already assigned in one or more plan templates';
$string['error:nodeletepriorityscaleinuse'] = 'You cannot delete that priority scale because it is in use';
$string['error:nodeletepriorityscalevaluedefault'] = 'You cannot delete that priority scale value because it is the default value';
$string['error:nodeletepriorityscalevalueinuse'] = 'You cannot delete that scale value because it\'s scale is in use';
$string['error:nopermissiondeletemandatorycomp'] = 'You do not have permission to delete a mandatory competency';
$string['error:nopermissiondeletemandatorycourse'] = 'You do not have permission to delete a mandatory course';
$string['error:nopermissions'] = 'You do not have the necessary permissions to perform this action';
$string['error:noprioritiesfound'] = 'No priorities found, please create a priority scale first.';
$string['error:noreorderobjectiveinuse'] = 'You cannot reorder an objective scale that is in use.';
$string['error:noreorderpriorityinuse'] = 'You cannot reorder a priority scale that is in use.';
$string['error:notemplatewithoutobjectivescale'] = 'You must create at least one objective scale before you can create a template.';
$string['error:notemplatewithoutpriorityscale'] = 'You must create at least one priority scale before you can create a template.';
$string['error:objectivedeleted'] = 'Objective not deleted';
$string['error:objectiveidincorrect'] = 'Objective ID incorrect';
$string['error:objectivenotfound'] = 'Objective not found';
$string['error:objectivescaledidincorrect'] = 'Incorrect Objective Scale ID';
$string['error:objectivescaleidincorrect'] = 'Objective Scale ID was incorrect';
$string['error:objectivescalevalueidincorrect'] = 'Objective Scale value ID was incorrect';
$string['error:objectivesupdated'] = 'Objectives not updated';
$string['error:objectiveupdated'] = 'Objective not updated';
$string['error:planhistory'] = 'Error, plan history not found';
$string['error:priorityscaleidincorrect'] = 'Priority Scale ID was incorrect';
$string['error:priorityscalevalueidincorrect'] = 'Priority Scale value ID was incorrect';
$string['error:problemapproving'] = 'There was a problem approving those items';
$string['error:propertymustbeset'] = 'Property \'{$a->property}\' must be set in class {$a->class}';
$string['error:reactivatedatebeforenow'] = 'Error, the new end date specified is before now.';
$string['error:recordoflearningdisabled'] = 'Record of Learning is not enabled on this site.';
$string['error:settingdoesnotexist'] = 'Setting {$a->action} does not exist in the component {$a->component}';
$string['error:templateid'] = 'Invalid plan template ID';
$string['error:unknownbuttonclicked'] = 'Unknown button clicked.';
$string['error:update_competency_settings'] = 'An error occured while updating the Competency settings';
$string['error:update_components_enabled'] = 'An error occured while enabling/disabling a Component';
$string['error:update_components_settings'] = 'An error occured while updating the Component settings';
$string['error:update_components_sortorder'] = 'An error occured which changing order of Components';
$string['error:update_course_settings'] = 'An error occured while updating the Course settings';
$string['error:update_general_settings'] = 'An error occured while updating the General settings';
$string['error:update_objective_settings'] = 'An error occured while updating the Objective settings';
$string['error:update_plan_settings'] = 'An error occured while updating the Plan settings';
$string['error:update_program_settings'] = 'An error occured while updating the program settings';
$string['error:update_workflow_settings'] = 'An error occured while updating the Workflow settings';
$string['error:updateevidencetype'] = 'An error occured while updating Evidence type';
$string['error:updateingrecord'] = 'Error, no such link type';
$string['error:updateobjectivescale'] = 'An error occured while updating objective scale';
$string['error:updateobjectivescaleordering'] = 'Could not update objective scale ordering';
$string['error:updateobjectivescalevalue'] = 'Could not update objective scale value';
$string['error:updatepriorityscaleordering'] = 'Could not update priority scale ordering';
$string['error:updatepriorityscalevalue'] = 'Could not update priority scale value.';
$string['error:updatetemplateordering'] = 'Could not update plan template ordering';
$string['error:updatinglinktype'] = 'Error: could not update link type';
$string['error:updatingpriorityscale'] = 'An error occured while updating priority scale';
$string['error:usernotfound'] = 'User not found';
$string['eventapprovalapproved'] = 'Plan Approval approved';
$string['eventapprovaldeclined'] = 'Plan Approval declined';
$string['eventapprovalrequested'] = 'Plan Approval requested';
$string['eventcomponentcreated'] = 'Plan component created';
$string['eventcomponentdeleted'] = 'Plan component deleted';
$string['eventcomponentupdated'] = 'Plan component updated';
$string['eventevidencecreated'] = 'Evidence created';
$string['eventevidencedeleted'] = 'Evidence deleted';
$string['eventevidencetypecreated'] = 'Evidence type created';
$string['eventevidencetypedeleted'] = 'Evidence type deleted';
$string['eventevidencetypeupdated'] = 'Evidence type updated';
$string['eventevidenceupdated'] = 'Evidence updated';
$string['eventobjectivescalecreated'] = 'Objective scale created';
$string['eventobjectivescaledeleted'] = 'Objective scale deleted';
$string['eventobjectivescaleupdated'] = 'Objective scale updated';
$string['eventplancompleted'] = 'Plan completion';
$string['eventplancreated'] = 'Plan created';
$string['eventplandeleted'] = 'Plan deleted';
$string['eventplanlistviewed'] = 'Plans viewed';
$string['eventplanreactivated'] = 'Plan reactivated';
$string['eventplanupdated'] = 'Plan updated';
$string['eventplanviewed'] = 'Plan viewed';
$string['eventpriorityscalecreated'] = 'Priority scale created';
$string['eventpriorityscaledeleted'] = 'Priority scale deleted';
$string['eventpriorityscaleupdated'] = 'Priority scale updated';
$string['eventtemplateupdated'] = 'Workflow changed in plan template';
$string['evidence'] = 'Evidence';
$string['evidence_instructions_add'] = 'You can add additional evidence by clicking the "Add/remove evidence" button to the right of the screen. ';
$string['evidence_instructions_add11'] = 'You can add additional evidence by clicking the "Add/remove evidence" button to the right of the screen. ';
$string['evidence_instructions_detail'] = 'You can view more details about any evidence by clicking its title. ';
$string['evidence_instructions_learner'] = 'All the evidence that will be addressed by your learning plan are shown below. ';
$string['evidence_instructions_manager'] = 'All the evidence that will be addressed by your team member\'s learning plan area shown below. ';
$string['evidence_instructions_request'] = 'Clicking "Update requested evidence" will allow you to request to add new evidence to this learning plan.';
$string['evidence_readonly'] = 'Evidence is read only';
$string['evidenceadded'] = 'Evidence created';
$string['evidenceattachmentdeleted'] = 'Attached evidence file has been deleted';
$string['evidencedatecompleted'] = 'Date completed';
$string['evidencedatecompletedshort'] = 'evidencedatecompleted';
$string['evidencedeleted'] = 'Evidence deleted';
$string['evidencedescription'] = 'Description';
$string['evidencedescriptionshort'] = 'evidencedescription';
$string['evidenceinstitution'] = 'Institution';
$string['evidenceinstitutionshort'] = 'evidenceinstitution';
$string['evidencelink'] = 'Link';
$string['evidencelinkshort'] = 'evidencelink';
$string['evidencefileattachments'] = 'File attachments';
$string['evidencefileattachmentsshort'] = 'evidencefileattachments';
$string['evidenceinuseby'] = 'This evidence is used by the following learning plan components';
$string['evidencelink'] = 'Evidence Link';
$string['evidencelinkerror'] = 'Not a valid web link';
$string['evidencename'] = 'Evidence name';
$string['evidenceplural'] = 'Evidence';
$string['evidencetype'] = 'Evidence type';
$string['evidencetypeadded'] = 'Evidence type "{$a}" added';
$string['evidencetypecreate'] = 'Add a new Evidence type';
$string['evidencetypeinuse'] = 'This evidence type is in use. You can still rename evidence types but this may confuse users when this changes without warning.';
$string['evidencetypename'] = 'Name';
$string['evidencetypes'] = 'Evidence types';
$string['evidencetypeupdated'] = 'Evidence type "{$a}" updated';
$string['evidencetypex'] = 'Evidence type "{$a}"';
$string['evidenceupdated'] = 'Evidence updated';
$string['evidenceview'] = 'View Evidence';
$string['evidencecustomfields'] = 'Evidence custom fields';
$string['explainobjscalevals'] = 'One value per line (highest to lowest)';
$string['explainpriorityscalevals'] = 'One priority per line (highest to lowest)';
$string['filterbystatus'] = 'Filter by status';
$string['general'] = 'General';
$string['generalsettings'] = 'General Settings';
$string['globallearningplansettings'] = 'Global Learning Plan Settings';
$string['globalsettings'] = 'Global Settings';
$string['hidden'] = 'Hidden';
$string['historyforcompetencyx'] = 'History for competency "{$a}"';
$string['includecompleted'] = 'Include completed competencies';
$string['includerelatedcourses'] = 'Include linked courses';
$string['inprogress'] = 'In progress';
$string['instances'] = 'Instances';
$string['invalidnumeric'] = 'Numerical value must be numerical (or not set)';
$string['item-request-manager-long'] = '{$a->learner} has requested approval for new learning plan items in "{$a->plan}": {$a->data}';
$string['item-request-manager-short'] = 'Item approval request by {$a->learner}';
$string['itemapproval'] = 'Item approval';
$string['items'] = 'Items';
$string['latestcommentby'] = 'Latest comment by';
$string['launchcourse'] = 'Launch course';
$string['launchprogram'] = 'Launch program';
$string['learner'] = 'Learner';
$string['learning'] = 'Learning';
$string['learningplan'] = 'Learning Plan';
$string['learningplan:name:tab'] = 'Learning Plan: {$a->name} - {$a->tab}';
$string['learningplans'] = 'Learning Plans';
$string['learningplansdisabled'] = 'Learning Plans are not enabled on this site.';
$string['linkedcompetencies'] = 'Linked competencies';
$string['linkedcourses'] = 'Linked courses';
$string['linkedobjectives'] = 'Linked objectives';
$string['linkedx'] = 'Linked {$a}';
$string['linktoobjectivevalues'] = 'View/edit the scale values for this objective scale.';
$string['linktopriorityvalues'] = 'View/edit the scale values for this priority scale.';
$string['linktype'] = 'Link type';
$string['manageplans'] = 'Manage plans';
$string['manager'] = 'Manager';
$string['managerdrivenworkflowdesc'] = 'The manager assigns content to their staff\'s learning plan. The user can request content be added but manager approval is required.';
$string['managerdrivenworkflowname'] = 'Manager driven workflow';
$string['managetemplates'] = 'Manage templates';
$string['mandatory'] = 'Mandatory';
$string['manualcomplete'] = 'Manually, by a user with \'complete\' permission';
$string['manuallycreated'] = 'Manually created plans';
$string['markplancomplete'] = 'Mark plan {$a} complete';
$string['missingobjectivescalevaluename'] = 'Objective Scale Value name is Required';
$string['missingpriorityscalevaluename'] = 'Missing priority scale value name';
$string['na'] = 'N/A';
$string['name'] = 'Name';
$string['namelink'] = 'Name (link)';
$string['newtemplate'] = 'New Template';
$string['nochanges'] = 'There are no changes';
$string['noclassfileforcomponent'] = 'Class file \'{$a->classfile}\' could not be found for component \'{$a->component}\'';
$string['noclassfileforrole'] = 'Class file \'{$a->classfile}\' could not be found for role of \'{$a->role}\'';
$string['noclassfileforworkflow'] = 'Class file \'{$a->classfile}\' could not be found for workflow \'{$a->workflow}\'';
$string['noclassforcomponent'] = 'Class \'{$a->class}\' does not exist for component \'{$a->component}\'.';
$string['noclassforrole'] = 'Class \'{$a->class}\' does not exist for role \'{$a->role}\'.';
$string['noclassforworkflow'] = 'Class \'{$a->class}\' does not exist for workflow \'{$a->workflow}\'';
$string['nocomments'] = 'No comments';
$string['nocompetencies'] = 'No competencies.';
$string['nocourses'] = 'No courses.';
$string['nodeleteevidencetypeinuse'] = 'Unable to delete this evidence type \'{$a}\' because it is in use';
$string['noduedate'] = 'No due date';
$string['noevidencelink'] = 'No link for this evidence';
$string['noevidencetypesdefined'] = 'No Evidence types have been defined';
$string['noitemsrequiringapproval'] = 'There are no items requiring approval';
$string['nolinkedcompetencies'] = 'No linked competencies.';
$string['nolinkedcourses'] = 'No linked courses.';
$string['nolinkedobjectives'] = 'No linked objectives.';
$string['nolinkedx'] = 'No linked {$a}.';
$string['nomanager'] = 'You don\'t have a manager allocated in your profile positions';
$string['none'] = 'None';
$string['nonsensicalachievedvalues'] = 'Warning: You have achieved values below non-achieved values in this scale. Remember that your scale should be ordered from most accomplished at the top, to least accomplished at the bottom.';
$string['noobjectives'] = 'No objectives.';
$string['noobjectivescales'] = 'To use objectives setup an objective scale';
$string['noobjectivescalevalues'] = 'There are no objective scale values defined for this objective scale.';
$string['noobjectivesdefined'] = 'No objectives defined';
$string['nopermission'] = 'You don\'t have permission to perform that action';
$string['noplans'] = 'No plans...';
$string['noprioritiesdefined'] = 'No priorities defined';
$string['nopriorityscales'] = 'To use priorities setup a priority scale';
$string['nopriorityscalevalues'] = 'There are no priority scale values defined for this priority scale.';
$string['noprograms'] = 'No programs.';
$string['notcompleted'] = 'Not completed';
$string['noteduedateswrongformat'] = 'NOTE: The indicated duedate field(s) did not update: wrong format';
$string['noteduedateswrongformatorrequired'] = 'NOTE: The indicated duedate field(s) did not update: required or wrong format';
$string['notemplates'] = 'No plan templates have been created';
$string['notemplatesetup'] = 'No plan templates have been set up yet';
$string['nox'] = 'No {$a}.';
$string['numaffectedusers'] = 'Number of affected users';
$string['numberoflinkedcourses'] = 'Courses';
$string['numberoflinkedevidence'] = 'Evidence';
$string['objective'] = 'Objective';
$string['objective_instructions_add'] = 'Clicking "Add New Objective" will allow you to add new objectives to this learning plan.';
$string['objective_instructions_add11'] = 'Clicking "Add New Objective" will allow you to add new objectives to this learning plan.';
$string['objective_instructions_detail'] = 'You can view any objective by clicking the objective title.';
$string['objective_instructions_learner'] = 'All the objectives that form your learning plan are shown below.';
$string['objective_instructions_manager'] = 'All the objectives that form your team member\'s learning plan are show below.';
$string['objective_instructions_request'] = 'Clicking "Add new objective" will allow you to request to add new objectives to this learning plan.';
$string['objectiveapproved'] = 'Objective Approval';
$string['objectivecompletelonglearner'] = '{$a->userfrom} has changed objective "{$a->objective}" to completed in learning plan "{$a->plan}"';
$string['objectivecompletelonglearnerhtml'] = '{$a->userfromhtml} has changed objective "{$a->objectivehtml}" to completed in learning plan "{$a->planhtml}"';
$string['objectivecompletelongmanager'] = '{$a->userfrom} has changed objective "{$a->objective}" to completed in learning plan "{$a->plan}"';
$string['objectivecompletelongmanagerhtml'] = '{$a->userfromhtml} has changed objective "{$a->objectivehtml}" to completed in learning plan "{$a->planhtml}"';
$string['objectivecompleteshortlearner'] = 'Completed objective "{$a}"';
$string['objectivecompleteshortmanager'] = '{$a} has completed an objective';
$string['objectivecourse'] = 'Assigned courses';
$string['objectivecreated'] = 'Objective created';
$string['objectivedeleted'] = 'Objective deleted';
$string['objectivedeletelonglearner'] = '{$a->userfrom} has deleted objective "{$a->objective}" in learning plan "{$a->plan}"';
$string['objectivedeletelonglearnerhtml'] = '{$a->userfromhtml} has deleted objective "{$a->objective}" in learning plan "{$a->planhtml}"';
$string['objectivedeletelongmanager'] = '{$a->userfrom} has deleted the objective "{$a->objective}" in learning plan "{$a->plan}"';
$string['objectivedeletelongmanagerhtml'] = '{$a->userfromhtml} has deleted the objective "{$a->objective}" in learning plan "{$a->planhtml}"';
$string['objectivedeleteshortlearner'] = 'Objective "{$a}" has been deleted';
$string['objectivedeleteshortmanager'] = '{$a} has deleted an objective';
$string['objectivedescription'] = 'Objective description';
$string['objectiveduedate'] = 'Objective Due Date';
$string['objectiveeditlonglearner'] = '{$a->userfrom} has edited {$a->field} for objective "{$a->objective}" in learning plan "{$a->plan}"';
$string['objectiveeditlonglearnerhtml'] = '{$a->userfromhtml} has edited {$a->field} for objective "{$a->objectivehtml}" in learning plan "{$a->planhtml}"';
$string['objectiveeditlongmanager'] = '{$a->userfrom} has edited {$a->field} for objective "{$a->objective}" in learning plan "{$a->plan}"';
$string['objectiveeditlongmanagerhtml'] = '{$a->userfromhtml} has edited {$a->field} for objective "{$a->objectivehtml}" in learning plan "{$a->planhtml}"';
$string['objectiveeditshortlearner'] = 'Objective "{$a}" has been edited';
$string['objectiveeditshortmanager'] = '{$a} has edited their objectives';
$string['objectivefullname'] = 'Objective title';
$string['objectiveincompletelonglearner'] = '{$a->userfrom} has changed objective "{$a->objective}" to incomplete in learning plan "{$a->plan}"';
$string['objectiveincompletelonglearnerhtml'] = '{$a->userfromhtml} has changed objective "{$a->objectivehtml}" to incomplete in learning plan "{$a->planhtml}"';
$string['objectiveincompletelongmanager'] = '{$a->userfrom} has changed objective "{$a->objective}" to incomplete in learning plan "{$a->plan}"';
$string['objectiveincompletelongmanagerhtml'] = '{$a->userfromhtml} has changed objective "{$a->objectivehtml}" to incomplete in learning plan "{$a->planhtml}"';
$string['objectiveincompleteshortlearner'] = 'Objective "{$a}" incomplete';
$string['objectiveincompleteshortmanager'] = '{$a} has an incomplete objective';
$string['objectivename'] = 'Objective Name';
$string['objectivenewlonglearner'] = '{$a->userfrom} has assigned new objective "{$a->objective}" to learning plan "{$a->plan}"';
$string['objectivenewlonglearnerhtml'] = '{$a->userfromhtml} has assigned new objective "{$a->objectivehtml}" to learning plan "{$a->planhtml}"';
$string['objectivenewlongmanager'] = '{$a->userfrom} has created new objective "{$a->objective}" in learning plan "{$a->plan}"';
$string['objectivenewlongmanagerhtml'] = '{$a->userfromhtml} has created new objective "{$a->objectivehtml}" in learning plan "{$a->planhtml}"';
$string['objectivenewshortlearner'] = 'New objective "{$a}" assigned';
$string['objectivenewshortmanager'] = '{$a} created new objective';
$string['objectivepermissions'] = 'Objective permissions';
$string['objectiveplural'] = 'Objectives';
$string['objectivepriority'] = 'Objective Priority';
$string['objectives'] = 'Objectives';
$string['objectivescale'] = 'Objective scale';
$string['objectivescaleadded'] = 'Objective scale "{$a}" added';
$string['objectivescaleassign'] = 'Objective scale';
$string['objectivescaleassign_help'] = 'A Objective scales define the criteria by which an objective can be measured. This is the name of scale the value is being added to.';
$string['objectivescaledefault'] = 'Default value';
$string['objectivescaledefault_help'] = 'The **Default Value** is the value automatically assigned to an objective in a learning plan when the objective is first added by a learner or manager.';
$string['objectivescaledefaultupdated'] = 'The scale\'s default value has been updated';
$string['objectivescaleinuse'] = 'This scale is in use (i.e. users have objectives marked with values from this scale). Scale values cannot be created, re-ordered or deleted to preserve data integrity. You can still rename scale values but this may confuse users when their objective status changes without warning.';
$string['objectivescalename'] = 'Objective scale name';
$string['objectivescalename_help'] = 'The name of the objective scale used by a learning plan.';
$string['objectivescales'] = 'Objective scales';
$string['objectivescalesdisabledtemplateinuse'] = 'NOTE: Cannot change objective scale - there are plans using this template';
$string['objectivescaleupdated'] = 'Objective scale "{$a}" updated';
$string['objectivescalevalueachieved'] = 'Achieved';
$string['objectivescalevalueachieved_help'] = 'When **Achieved** is checked this objective scale value will be used to indicate the objective is achieved by the learner.

You can have multiple values marked as **Achieved** allowing degrees of achievement.';
$string['objectivescalevalueadded'] = 'Objective scale value "{$a}" added';
$string['objectivescalevalueid'] = 'Objective Proficiency';
$string['objectivescalevalueidnumber'] = 'Scale value ID number';
$string['objectivescalevalueidnumber_help'] = 'Scale ID number is a unique number used to represent the scale value.';
$string['objectivescalevaluename'] = 'Scale value name';
$string['objectivescalevaluename_help'] = '**Scale value name** is the name of the objective scale value you are adding or editing.

A scale value is used to measure the learning plan objectives. You can add as many scale values as required.';
$string['objectivescalevaluenumeric'] = 'Objective scale numerical value';
$string['objectivescalevaluenumeric_help'] = '**Objective scale value numerical value** allows you to assign a numerical value alongside a description (name) for the scale value.';
$string['objectivescalevalues'] = 'Objective scale values';
$string['objectivescalevalues_help'] = 'Enter a list of values for the new objective scale (one value per line), in order from highest to lowest. For example:

<p class="indent">
  <em> High<br /> Medium<br /> Low </em>
</p>';
$string['objectivescalevalueupdated'] = 'Objective scale value "{$a}" updated';
$string['objectivescalex'] = 'Objective scale "{$a}"';
$string['objectivesettings'] = 'Objective settings';
$string['objectivesmet'] = 'Objectives met';
$string['objectivesnotupdated'] = 'Objectives not updated';
$string['objectivesscalecreate'] = 'Add a new objective scale';
$string['objectivesupdated'] = 'Objectives updated';
$string['objectivetitle'] = 'Objective Title';
$string['objectiveupdated'] = 'Objective updated';
$string['objectivevalues'] = 'Objective Values';
$string['on'] = 'on';
$string['optional'] = 'Optional';
$string['options'] = 'Options';
$string['overdue'] = 'Overdue!';
$string['overview'] = 'Overview';
$string['pendingapproval'] = 'Pending approval';
$string['pendingitems'] = 'Pending approval';
$string['pendingitemsx'] = '<a href="{$a->link}" title="Plan item(s) requiring approval ({$a->count})"><span class="redfont">Pending ({$a->count})</span></a>';
$string['pendingremoval'] = 'Pending removal';
$string['plan'] = 'Plan';
$string['plan-add-learner-long'] = 'New learning plan "{$a->plan}" has been assigned by {$a->manager}';
$string['plan-add-learner-short'] = 'New plan "{$a->plan}" assigned';
$string['plan-approve-learner-long'] = 'Approval request for learning plan "{$a->plan}" has been granted';
$string['plan-approve-learner-short'] = 'New plan "{$a->plan}" approved';
$string['plan-complete-manager-long'] = '{$a->learner} completed learning plan "{$a->plan}"';
$string['plan-complete-manager-short'] = '{$a->learner} completed plan';
$string['plan-decline-learner-long'] = 'Approval request for learning plan "{$a->plan}" has been declined';
$string['plan-decline-learner-short'] = 'New plan approval request declined';
$string['plan-due-learner-long'] = 'Learning plan "{$a->plan}" is due in {$a->numdays} days';
$string['plan-due-learner-short'] = 'Plan "{$a->plan}" is due in {$a->numdays} days';
$string['plan-due-today-learner-long'] = 'Learning plan "{$a->plan}" is due today';
$string['plan-due-today-learner-short'] = 'Plan "{$a->plan}" is due today';
$string['plan-duedate-update-learner-long'] = 'Due date for learning plan "{$a->plan}" has been changed';
$string['plan-duedate-update-learner-short'] = 'Plan due date has been changed';
$string['plan-duedate-update-manager-long'] = 'Due date for {$a->learner}\'s learning plan "{$a->plan}" has been changed';
$string['plan-duedate-update-manager-short'] = '{$a->learner} changed a plan due date';
$string['plan-newcomment-learner-long'] = '{$a->manager} commented on learning plan "{$a->plan}"';
$string['plan-newcomment-learner-short'] = '{$a->manager} commented on plan';
$string['plan-newcomment-manager-long'] = '{$a->learner} commented on learning plan "{$a->plan}"';
$string['plan-newcomment-manager-short'] = '{$a->learner} commented on plan';
$string['plan-overdue-learner-long'] = 'Learning plan "{$a->plan}" is overdue';
$string['plan-overdue-learner-short'] = 'Plan "{$a->plan}" is overdue';
$string['plan-overdue-manager-long'] = '{$a->learner}\s learning plan "{$a->plan}" is overdue';
$string['plan-overdue-manager-short'] = '{$a->learner}\s plan is overdue';
$string['plan-reactivate-learner-long'] = 'Learning plan "{$a->plan}" has been reactivated by {$a->manager}';
$string['plan-reactivate-learner-short'] = 'Plan "{$a->plan}" has been reactivated';
$string['plan-reactivate-manager-long'] = '{$a->learner} has reactivated the learning plan "{$a->plan}"';
$string['plan-reactivate-manager-short'] = '{$a->learner} has reactivated plan';
$string['plan-remove-learner-long'] = 'Learning plan "{$a->plan}" has been deleted by {$a->manager}';
$string['plan-remove-learner-short'] = 'Plan "{$a->plan}" has been deleted';
$string['plan-remove-manager-long'] = '{$a->learner} has deleted the learning plan "{$a->plan}"';
$string['plan-remove-manager-short'] = '{$a->learner} has deleted plan';
$string['plan-request-learner-long'] = 'Requested approval for new learning plan "{$a->plan}"';
$string['plan-request-learner-short'] = 'New plan approval request';
$string['plan-request-manager-long'] = '{$a->learner} has requested approval for a new learning plan "{$a->plan}"';
$string['plan-request-manager-short'] = 'New plan approval request by {$a->learner}';
$string['plan:accessanyplan'] = 'Access any user\'s plan';
$string['plan:accessplan'] = 'Access plan';
$string['plan:add'] = 'Add plans';
$string['plan:cancreateplancohort'] = 'Create plans for audiences';
$string['plan:canselectplantemplate'] = 'Select plan template';
$string['plan:configureplans'] = 'Configure plan templates';
$string['plan:editownsiteevidence'] = 'Edit one\'s own site-level evidence';
$string['plan:editsiteevidence'] = 'Edit site-level evidence';
$string['plan:evidencemanagecustomfield'] = 'Manage evidence item custom fields';
$string['plan:manageanyplan'] = 'Manage any user\'s plan';
$string['plan:manageevidencetypes'] = 'Manage evidence types';
$string['plan:manageobjectivescales'] = 'Manage objective scales';
$string['plan:managepriorityscales'] = 'Manage priority scales';
$string['plan_instructions_delete'] = 'You can delete this learning plan by clicking the "Deleting plan" button.';
$string['plan_instructions_edit'] = 'You can click the "Edit details" button to ammend the learning plan title, short description or completion date.';
$string['plan_instructions_learner'] = 'Below is a short summary of your learning plan.';
$string['plan_instructions_manager'] = 'Below is a short summary of your team member\'s learning plan.';
$string['planapproved'] = 'Plan "{$a}" has been approved';
$string['planapprovedby'] = 'Plan "{$a->name}" has been approved by {$a->user}';
$string['planactivated'] = 'Plan "{$a}" has been activated';
$string['planautocompleteddate'] = 'This plan has been automatically completed because the end date for the plan has passed.';
$string['planautocompleteditems'] = 'This plan has been automatically completed because all the items in it have been completed.';
$string['plancomplete'] = 'Complete plan';
$string['plancompleted'] = 'This plan has been marked as complete. It can no longer be edited, and all status indicators show the status at the time of the plan\'s completion.';
$string['plancompletefail'] = 'There was a problem while trying to mark plan "{$a}" as complete';
$string['plancompletesuccess'] = 'Successfully completed plan {$a}';
$string['plancreatefail'] = 'Plan "{$a}" could not be created';
$string['plancreatesuccess'] = 'Plan creation successful';
$string['plandeclined'] = 'Plan "{$a}" has been declined';
$string['plandeclinedby'] = 'Plan "{$a->name}" has been declined by {$a->user}';
$string['plandeclinedtryagain'] = 'This plan has been declined. If desired, you can make changes and request plan approval again.';
$string['plandeletefail'] = 'Could not delete plan "{$a}"';
$string['plandeletesuccess'] = 'Successfully deleted plan "{$a}"';
$string['plandescription'] = 'Plan description';
$string['plandetails'] = 'Plan details';
$string['planhasunapproveditem'] = 'This plan has a draft item:';
$string['planhasunapproveditems'] = 'This plan has draft items:';
$string['planidnotfound'] = 'Plan ID of \'{$a}\' not found';
$string['planinstructions'] = 'Your current and completed learning plans are shown below. ';
$string['planinstructions_add'] = 'You can create a new learning plan by clicking "Create a new learning plan" to the right of the screen. ';
$string['planinstructions_noadd'] = 'You do not currently have permission to create a Learning Plan. ';
$string['planinstructionsuser'] = '{$a}\'s current and completed learning plans are shown below. ';
$string['planmarkedcomplete'] = 'Plan marked as complete';
$string['planname'] = 'Plan name';
$string['plannotapproved'] = 'This plan has not yet been approved';
$string['plannotactivated'] = 'Your plan has not been activated';
$string['planpermissions'] = 'Plan permissions';
$string['planreactivate'] = 'Reactivate plan';
$string['planreactivatefail'] = 'There was a problem while trying to reactivate plan "{$a}"';
$string['planreactivatesuccess'] = 'Successfully reactivated plan {$a}';
$string['plansettings'] = 'Plan settings';
$string['planstatus'] = 'Plan status';
$string['planstatusunapproved'] = 'Unapproved';
$string['plantemplate'] = 'Plan template';
$string['planupdatecancelled'] = 'Plan update cancelled';
$string['planupdatefail'] = 'Plan update failed';
$string['planupdatesuccess'] = 'Plan update successful';
$string['pluginname'] = 'Learning Plans';
$string['priorities'] = 'Priorities';
$string['priority'] = 'Priority';
$string['priorityof'] = 'Priority of {$a}';
$string['prioritymode'] = 'Priorities';
$string['priorityscale'] = 'Priority scale';
$string['priorityscaleadded'] = 'Priority scale "{$a}" added';
$string['priorityscaleassign'] = 'Priority scale assign';
$string['priorityscaleassign_help'] = 'A **Priority scale** is the name of the priority scale you are working in.';
$string['priorityscalecreate'] = 'Add a new priority scale';
$string['priorityscaledefault'] = 'Default value';
$string['priorityscaledefault_help'] = 'The **Default Value** is the value which is automatically assigned to a learning plan item when the priority scale first appears in the learner\'s plan. The priority can later be changed by the learner/manager once active within the learning plan.';
$string['priorityscaledefaultupdated'] = 'The scale\'s default value has been updated';
$string['priorityscaleinuse'] = 'This scale is in use (i.e. users have items marked with values from this scale). Scale values cannot be created, re-ordered or deleted to preserve data integrity. You can still rename scale values but this may confuse users when their priorities changes without warning.';
$string['priorityscalename'] = 'Priority scale name';
$string['priorityscalename_help'] = 'The name of the priority scale used by a learning plan.';
$string['priorityscales'] = 'Priority scales';
$string['priorityscalesdisabledtemplateinuse'] = 'NOTE: Cannot change priority scale - there are plans using this template';
$string['priorityscaleupdated'] = 'Priority scale "{$a}" updated';
$string['priorityscalevalueadded'] = 'Priority scale value "{$a}" added';
$string['priorityscalevalueidnumber'] = 'Scale value ID number';
$string['priorityscalevalueidnumber_help'] = 'Scale ID number is a unique number used to represent the scale value.';
$string['priorityscalevaluename'] = 'Scale value name';
$string['priorityscalevaluename_help'] = '**Scale value name** is the name of the value you are adding or editing for a specific priority scale.

A scale value is used to define the priority for a learning plan item. You can add as many scale values as required.';
$string['priorityscalevaluenumeric'] = 'Priority scale numerical value';
$string['priorityscalevaluenumeric_help'] = '**Priority scale value numerical value** enables you to assign a numerical value to this scale value as well as the description (name).';
$string['priorityscalevalues'] = 'Priority scale values';
$string['priorityscalevalues_help'] = 'Enter a list of values for the new priority scale (one priority per line), in order from highest priority to lowest. For example:

<p class="indent">
  <em> High<br /> Medium<br /> Low </em>
</p>';
$string['priorityscalevalueupdated'] = 'Priority scale value "{$a}" updated';
$string['priorityscalex'] = 'Priority scale "{$a}"';
$string['priorityvalues'] = 'Priority values';
$string['proficiency'] = 'Proficiency';
$string['program'] = 'Program';
$string['program_instructions_add'] = 'Clicking "Add/remove programs" will allow you to add new programs to this learning plan.';
$string['program_instructions_add11'] = 'Clicking "Add programs" will allow you to add new programs to this learning plan.';
$string['program_instructions_detail'] = 'You can view any program by clicking the program title.';
$string['program_instructions_learner'] = 'All the programs that form your learning plan are shown below.';
$string['program_instructions_manager'] = 'All the programs that form your team member\'s learning plan are show below.';
$string['program_instructions_request'] = 'Clicking "Add programs" will allow you to request to add new programs to this learning plan.';
$string['programname'] = 'Program Name';
$string['programnotfound'] = 'Program not found';
$string['programpermissions'] = 'Program permissions';
$string['programplural'] = 'Programs';
$string['programscompletionhistoryforsubhead'] = 'Previous Completions for {$a}';
$string['programscompletionhistorysubhead'] = 'Previous Completed Programs';
$string['programsettings'] = 'Program settings';
$string['programsupdated'] = 'Program settings updated.';
$string['progress'] = 'Progress';
$string['reactivate'] = 'Reactivate';
$string['reactivateplantext'] = 'If you want to make changes or continue using this plan, it must first be reactivated.<br /><a href="{$a}">Reactivate</a> this plan.';
$string['reasonapprovedplanrequest'] = 'The reason given for approving the plan was: {$a}';
$string['reasondeclinedplanrequest'] = 'The reason given for declining the plan was: {$a}';
$string['reasonforapprovedecline'] = 'Reason for approving/declining {$a}';
$string['reasongivenfordecision'] = 'The reason given for this decision was: {$a}';
$string['recordoflearning'] = 'Record of Learning';
$string['recordoflearningcertifications'] = 'Record of Learning: Certifications';
$string['recordoflearningcertificationshistory'] = 'Record of Learning: Previous Certifications';
$string['recordoflearningcompetencies'] = 'Record of Learning: Competencies';
$string['recordoflearningcourses'] = 'Record of Learning: Courses';
$string['recordoflearningcoursescompletionhistory'] = 'Record of Learning: Courses Completion History';
$string['recordoflearningevidence'] = 'Record of Learning: Evidence';
$string['recordoflearningobjectives'] = 'Record of Learning: Objectives';
$string['recordoflearningprograms'] = 'Record of Learning: Programs';
$string['recordoflearningprogramscompletionhistory'] = 'Record of Learning: Programs Completion History';
$string['recordoflearningprogramsrecurring'] = 'Record of Learning: Recurring programs';
$string['remove'] = 'Select Linked {$a}';
$string['removedx'] = 'Removed "{$a}"';
$string['removeselected'] = 'Remove selected links';
$string['request'] = 'Request';
$string['requestapproval'] = 'Request approval';
$string['requestapprove'] = 'Request approved.';
$string['requestdecline'] = 'Request declined.';
$string['requestednewobjective'] = 'Add a new objective request';
$string['requestnotapprove'] = 'There was a problem while trying to approve that request';
$string['requestnotdecline'] = 'There was a problem while trying to decline that request';
$string['requestremoval'] = 'Request removal';
$string['required'] = 'Required';
$string['review'] = 'Review';
$string['reviewitemstext'] = 'Please review the changes to the attached plan';
$string['reviewplantext'] = 'Please review the attached plan';
$string['role'] = 'Role';
$string['rpl'] = 'Recognition of Prior Learning';
$string['rplupdated'] = 'Recognition of Prior Learning updated';
$string['save'] = 'Save';
$string['scales'] = 'Priority Scales';
$string['scaleslocked'] = 'This template is in use and changing the scales will impact data integrity. Therefore Priority and Objective scales are locked and will not be updated when the workflow is changed.';
$string['selectanevidencetype'] = 'Select an evidence type';
$string['selectasdefault'] = 'Select {$a} as default';
$string['selectedlinkedcompetenciesremovedfromcourse'] = 'The selected linked competencies have been removed from this course';
$string['selectedlinkedcoursesremovedfromcompetency'] = 'The selected linked courses have been removed from this competency';
$string['selectedlinkedcoursesremovedfromobjective'] = 'The selected linked courses have been removed from this objective';
$string['selectedlinkedevidenceremovedfromcompetency'] = 'The selected linked evidence have been removed from this competency';
$string['selectedlinkedevidenceremovedfromcourse'] = 'The selected linked evidence have been removed from this course';
$string['selectedlinkedevidenceremovedfromobjective'] = 'The selected linked evidence have been removed from this objective';
$string['selectedlinkedevidenceremovedfromprogram'] = 'The selected linked evidence have been removed from this program';
$string['selectlinked'] = 'Select linked {$a->name} {$a->component}';
$string['sendapprovalrequest'] = 'Send approval request';
$string['set'] = 'Set';
$string['setcompetencystatus'] = 'Set competency status';
$string['setcompletionstatus'] = 'Set Completion Status';
$string['setdefaultstatus'] = 'Assign newly approved competencies their default status';
$string['setduedate'] = 'Set Due Date';
$string['setpriority'] = 'Set Priority';
$string['setproficiency'] = 'Set Status';
$string['setstatusicon'] = 'Set Status';
$string['setting'] = 'Setting';
$string['signoff'] = 'Sign-off';
$string['simpleworkflow'] = 'Simple workflow settings';
$string['startdate'] = 'Start date';
$string['status'] = 'Status';
$string['statusof'] = 'Status of {$a}';
$string['teammembers'] = 'Team Members';
$string['templatecomponentsettings'] = 'Component Settings';
$string['templatecomponentsettings_help'] = 'The **Component Settings** allows you to show/hide components in the learning plan and define the order in which they appear.

Click **Hide** to remove a component from the learning plan template.

Use the up and down arrows to change the order of the components.';
$string['templateenddate'] = 'End Date';
$string['templateenddate_help'] = 'Click the calendar icon to select the **End date** for the learning plan template.';
$string['templateinstances'] = 'Template Instances';
$string['thefollowingitemsarepending_p'] = 'This plan contains the following pending items:';
$string['thefollowingitemsarepending_s'] = 'This plan contains the following pending item:';
$string['thefollowingitemsrequireyourapproval_p'] = 'This plan contains new items that require your approval:';
$string['thefollowingitemsrequireyourapproval_s'] = 'This plan contains a new item that requires your approval:';
$string['todb_competencysettingerror'] = 'Error updating competency settings';
$string['todb_coursesettingerror'] = 'Error updating course settings';
$string['todb_objectivesettingerror'] = 'Error updating objective settings';
$string['todb_programsettingerror'] = 'Error updating program settings';
$string['todb_updatepermissionserror'] = 'Error updating template permissions';
$string['unabletoassigncompsfromorg'] = 'Unable to assign competencies from organisation';
$string['unabletoassigncompsfrompos'] = 'Unable to assign competencies from position';
$string['unapproved'] = 'Draft';
$string['unapprovedplans'] = 'Unapproved Plans';
$string['unknown'] = 'Unknown';
$string['unknownuserslearningplans'] = 'Unknown User\'s Learning Plans';
$string['update'] = 'Update';
$string['update_competency_settings'] = 'Competency settings successfully updated';
$string['update_components_settings'] = 'Component settings successfully updated';
$string['update_course_settings'] = 'Course settings successfully updated';
$string['update_general_settings'] = 'General settings successfully updated';
$string['update_objective_settings'] = 'Objective settings successfully updated';
$string['update_plan_settings'] = 'Plan settings successfully updated';
$string['update_program_settings'] = 'Program settings successfully updated';
$string['update_workflow_settings'] = 'Workflow settings successfully updated';
$string['updatecompetency'] = 'Update';
$string['updatecourse'] = 'Update';
$string['updatecourses'] = 'Update courses';
$string['updateevidence'] = 'Update evidence';
$string['updatelinkedx'] = 'Update linked {$a}';
$string['updateobjective'] = 'Update objective';
$string['updateobjectives'] = 'Update objectives';
$string['updateplan'] = 'Update plan';
$string['updateprogram'] = 'Update';
$string['updateprograms'] = 'Update programs';
$string['updaterequestedcompetency'] = 'Update requested competencies';
$string['updatesettings'] = 'Update Settings';
$string['usepriority'] = 'Use priority';
$string['userdrivenworkflowdesc'] = 'The user has control over their learning plan and can perform most actions themselves. The manager can view the plan but not make changes.';
$string['userdrivenworkflowname'] = 'User driven workflow';
$string['view'] = 'View';
$string['viewitem'] = 'View item';
$string['workflow'] = 'Workflow';
$string['workflowsettings'] = 'Workflow settings';
$string['xitemspending'] = '<a href="{$a->link}">{$a->number} {$a->name}</a> pending';
$string['xitemsunapproved'] = '<a href="{$a->uri}">{$a->number} {$a->name}</a>';
$string['xslearningplans'] = '{$a}\'s Learning Plans';
$string['youareviewingxsplan'] = '<strong>You are viewing <a href="{$a->site}/user/view.php?id={$a->userid}">{$a->name}\'s</a> plan.</strong>';
$string['youareviewingxsplans'] = '<strong>You are viewing <a href="{$a->site}/user/view.php?id={$a->userid}">{$a->name}\'s</a> plans.</strong>';


/*
 * DEPRECATED
 */

$string['backtoallx'] = '&laquo; Back to all {$a}';
$string['backtoitem'] = '&laquo; Back to {$a}';
